<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * circuitkit module version information
 *
 * @package mod_circuitkit
 * @copyright  29/07/2025 Damien Renou (http://openelearning.org)
 * @copyright  29/07/2025 QUIQUEREZ Laurent (https://www.univ-lyon1.fr/)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require('../../config.php');
require_once($CFG->dirroot.'/mod/circuitkit/lib.php');
require_once($CFG->dirroot.'/mod/circuitkit/locallib.php');
require_once($CFG->libdir.'/completionlib.php');

$id      = optional_param('id', 0, PARAM_INT); // Course Module ID
$p       = optional_param('p', 0, PARAM_INT);  // circuitkit instance ID
$inpopup = optional_param('inpopup', 0, PARAM_BOOL);

if ($p) {
    if (!$circuitkit = $DB->get_record('circuitkit', array('id'=>$p))) {
        print_error('invalidaccessparameter');
    }
    $cm = get_coursemodule_from_instance('circuitkit', $circuitkit->id, $circuitkit->course, false, MUST_EXIST);

} else {
    if (!$cm = get_coursemodule_from_id('circuitkit', $id)) {
        print_error('invalidcoursemodule');
    }
    $circuitkit = $DB->get_record('circuitkit', array('id'=>$cm->instance), '*', MUST_EXIST);
}

$course = $DB->get_record('course', array('id'=>$cm->course), '*', MUST_EXIST);

require_course_login($course, true, $cm);
$context = context_module::instance($cm->id);
require_capability('mod/circuitkit:view', $context);

// Completion and trigger events.
circuitkit_view($circuitkit, $course, $cm, $context);

$PAGE->set_url('/mod/circuitkit/view.php', array('id' => $cm->id));

$options = empty($circuitkit->displayoptions) ? [] : (array) unserialize_array($circuitkit->displayoptions);

$activityheader = ['hidecompletion' => false];
if (empty($options['printintro']) || !trim(strip_tags($circuitkit->intro))) {
    $activityheader['description'] = '';
}

if ($inpopup and $circuitkit->display == RESOURCELIB_DISPLAY_POPUP) {
    $PAGE->set_pagelayout('popup');
    $PAGE->set_title($course->shortname.': '.$circuitkit->name);
    $PAGE->set_heading($course->fullname);
} else {
    $PAGE->add_body_class('limitedwidth');
    $PAGE->set_title($course->shortname.': '.$circuitkit->name);
    $PAGE->set_heading($course->fullname);
    $PAGE->set_activity_record($circuitkit);
    if (!$PAGE->activityheader->is_title_allowed()) {
        $activityheader['title'] = "";
    }
}

$PAGE->activityheader->set_attrs($activityheader);
echo $OUTPUT->header();

// Build the complete circuit URL
$engine_url = circuitkit_build_circuit_url($circuitkit->content);

// Add readonly parameter if enabled
if (!empty($circuitkit->readonly)) {
    $separator = (strpos($engine_url, '?') !== false) ? '&' : '?';
    $engine_url = $engine_url . $separator . 'r=1&mouseMode=None';
}

// Add hidemenu parameter if enabled
if (!empty($circuitkit->hidemenu)) {
    $separator = (strpos($engine_url, '?') !== false) ? '&' : '?';
    $engine_url = $engine_url . $separator . 'h=1';
}

$iframe_html = '<iframe src="' . $engine_url . '" width="100%" height="600px" frameborder="0" style="border: 1px solid #ccc;"></iframe>';
echo $OUTPUT->box($iframe_html, "generalbox center clearfix");

if (!isset($options['printlastmodified']) || !empty($options['printlastmodified'])) {
    $strlastmodified = get_string("lastmodified");
    echo html_writer::div("$strlastmodified: " . userdate($circuitkit->timemodified), 'modified');
}

echo $OUTPUT->footer();
