<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * circuitkit module admin settings and defaults
 *
 * @package mod_circuitkit
 * @copyright  29/07/2025 Damien Renou (http://openelearning.org)
 * @copyright  29/07/2025 QUIQUEREZ Laurent (https://www.univ-lyon1.fr/)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die;

if ($ADMIN->fulltree) {
    require_once("$CFG->libdir/resourcelib.php");

    $displayoptions = resourcelib_get_displayoptions(array(RESOURCELIB_DISPLAY_OPEN, RESOURCELIB_DISPLAY_POPUP));
    $defaultdisplayoptions = array(RESOURCELIB_DISPLAY_OPEN);

    //--- general settings -----------------------------------------------------------------------------------
    $settings->add(new admin_setting_configmultiselect('circuitkit/displayoptions',
        get_string('displayoptions', 'circuitkit'), get_string('configdisplayoptions', 'circuitkit'),
        $defaultdisplayoptions, $displayoptions));

    //--- modedit defaults -----------------------------------------------------------------------------------
    $settings->add(new admin_setting_heading('circuitkitmodeditdefaults', get_string('modeditdefaults', 'admin'), get_string('condifmodeditdefaults', 'admin')));

    $settings->add(new admin_setting_configcheckbox('circuitkit/printintro',
        get_string('printintro', 'circuitkit'), get_string('printintroexplain', 'circuitkit'), 0));
    $settings->add(new admin_setting_configcheckbox('circuitkit/printlastmodified',
        get_string('printlastmodified', 'circuitkit'), get_string('printlastmodifiedexplain', 'circuitkit'), 1));
    $settings->add(new admin_setting_configselect('circuitkit/display',
        get_string('displayselect', 'circuitkit'), get_string('displayselectexplain', 'circuitkit'), RESOURCELIB_DISPLAY_OPEN, $displayoptions));
    $settings->add(new admin_setting_configtext('circuitkit/popupwidth',
        get_string('popupwidth', 'circuitkit'), get_string('popupwidthexplain', 'circuitkit'), 620, PARAM_INT, 7));
    $settings->add(new admin_setting_configtext('circuitkit/popupheight',
        get_string('popupheight', 'circuitkit'), get_string('popupheightexplain', 'circuitkit'), 450, PARAM_INT, 7));
}
