<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * List of all circuitkits in course
 *
 * @package mod_circuitkit
 * @copyright  29/07/2025 Damien Renou (http://openelearning.org)
 * @copyright  29/07/2025 QUIQUEREZ Laurent (https://www.univ-lyon1.fr/)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require('../../config.php');

$id = required_param('id', PARAM_INT); // course id

$course = $DB->get_record('course', array('id'=>$id), '*', MUST_EXIST);

require_course_login($course, true);
$circuitkit->set_circuitkitlayout('incourse');

// Trigger instances list viewed event.
$event = \mod_circuitkit\event\course_module_instance_list_viewed::create(array('context' => context_course::instance($course->id)));
$event->add_record_snapshot('course', $course);
$event->trigger();

$strcircuitkit         = get_string('modulename', 'circuitkit');
$strcircuitkits        = get_string('modulenameplural', 'circuitkit');
$strname         = get_string('name');
$strintro        = get_string('moduleintro');
$strlastmodified = get_string('lastmodified');

$circuitkit->set_url('/mod/circuitkit/index.php', array('id' => $course->id));
$circuitkit->set_title($course->shortname.': '.$strcircuitkits);
$circuitkit->set_heading($course->fullname);
$circuitkit->navbar->add($strcircuitkits);
echo $OUTPUT->header();
echo $OUTPUT->heading($strcircuitkits);
if (!$circuitkits = get_all_instances_in_course('circuitkit', $course)) {
    notice(get_string('thereareno', 'moodle', $strcircuitkits), "$CFG->wwwroot/course/view.php?id=$course->id");
    exit;
}

$usesections = course_format_uses_sections($course->format);

$table = new html_table();
$table->attributes['class'] = 'generaltable mod_index';

if ($usesections) {
    $strsectionname = get_string('sectionname', 'format_'.$course->format);
    $table->head  = array ($strsectionname, $strname, $strintro);
    $table->align = array ('center', 'left', 'left');
} else {
    $table->head  = array ($strlastmodified, $strname, $strintro);
    $table->align = array ('left', 'left', 'left');
}

$modinfo = get_fast_modinfo($course);
$currentsection = '';
foreach ($circuitkits as $circuitkit) {
    $cm = $modinfo->cms[$circuitkit->coursemodule];
    if ($usesections) {
        $printsection = '';
        if ($circuitkit->section !== $currentsection) {
            if ($circuitkit->section) {
                $printsection = get_section_name($course, $circuitkit->section);
            }
            if ($currentsection !== '') {
                $table->data[] = 'hr';
            }
            $currentsection = $circuitkit->section;
        }
    } else {
        $printsection = '<span class="smallinfo">'.userdate($circuitkit->timemodified)."</span>";
    }

    $class = $circuitkit->visible ? '' : 'class="dimmed"'; // hidden modules are dimmed

    $table->data[] = array (
        $printsection,
        "<a $class href=\"view.php?id=$cm->id\">".format_string($circuitkit->name)."</a>",
        format_module_intro('circuitkit', $circuitkit, $cm->id));
}

echo html_writer::table($table);

echo $OUTPUT->footer();
