<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * circuitkit module upgrade code
 *
 * This file keeps track of upgrades to
 * the resource module
 *
 * Sometimes, changes between versions involve
 * alterations to database structures and other
 * major things that may break installations.
 *
 * The upgrade function in this file will attempt
 * to perform all the necessary actions to upgrade
 * your older installation to the current version.
 *
 * If there's something it cannot do itself, it
 * will tell you what you need to do.
 *
 * The commands in here will all be database-neutral,
 * using the methods of database_manager class
 *
 * Please do not forget to use upgrade_set_timeout()
 * before any action that may take longer time to finish.
 *
 * @package mod_circuitkit
 * @copyright  29/07/2025 Damien Renou (http://openelearning.org)
 * @copyright  29/07/2025 QUIQUEREZ Laurent (https://www.univ-lyon1.fr/)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die;

function xmldb_circuitkit_upgrade($oldversion) {
    global $CFG, $DB;

    $dbman = $DB->get_manager();

    // Automatically generated Moodle v3.6.0 release upgrade line.
    // Put any upgrade step following this.

    // Automatically generated Moodle v3.7.0 release upgrade line.
    // Put any upgrade step following this.

    // Automatically generated Moodle v3.8.0 release upgrade line.
    // Put any upgrade step following this.

    // Automatically generated Moodle v3.9.0 release upgrade line.
    // Put any upgrade step following this.

    // Automatically generated Moodle v4.0.0 release upgrade line.
    // Put any upgrade step following this.

    // Add readonly field for version 2025082900
    if ($oldversion < 2025082900) {
        // Define field readonly to be added to circuitkit.
        $table = new xmldb_table('circuitkit');
        $field = new xmldb_field('readonly', XMLDB_TYPE_INTEGER, '1', null, XMLDB_NOTNULL, null, '0', 'displayoptions');

        // Conditionally launch add field readonly.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Circuitkit savepoint reached.
        upgrade_mod_savepoint(true, 2025082900, 'circuitkit');
    }

    // Add hidemenu field for version 2025090300
    if ($oldversion < 2025090300) {
        // Define field hidemenu to be added to circuitkit.
        $table = new xmldb_table('circuitkit');
        $field = new xmldb_field('hidemenu', XMLDB_TYPE_INTEGER, '1', null, XMLDB_NOTNULL, null, '0', 'readonly');

        // Conditionally launch add field hidemenu.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Circuitkit savepoint reached.
        upgrade_mod_savepoint(true, 2025090300, 'circuitkit');
    }

    return true;
}
