<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * circuitkit external functions and service definitions.
 *
 * @package    mod_circuitkit
 * @category   external
 * @copyright  29/07/2025 Damien Renou (http://openelearning.org)
 * @copyright  29/07/2025 QUIQUEREZ Laurent (https://www.univ-lyon1.fr/)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since      Moodle 3.0
 */

defined('MOODLE_INTERNAL') || die;

$functions = array(

    'mod_circuitkit_view_circuitkit' => array(
        'classname'     => 'mod_circuitkit_external',
        'methodname'    => 'view_circuitkit',
        'description'   => 'Simulate the view.php web interface circuitkit: trigger events, completion, etc...',
        'type'          => 'write',
        'capabilities'  => 'mod/circuitkit:view',
        'services'      => array(MOODLE_OFFICIAL_MOBILE_SERVICE)
    ),

    'mod_circuitkit_get_circuitkits_by_courses' => array(
        'classname'     => 'mod_circuitkit_external',
        'methodname'    => 'get_circuitkits_by_courses',
        'description'   => 'Returns a list of circuitkits in a provided list of courses, if no list is provided all circuitkits that the user
                            can view will be returned.',
        'type'          => 'read',
        'capabilities'  => 'mod/circuitkit:view',
        'services'      => array(MOODLE_OFFICIAL_MOBILE_SERVICE),
    ),
);
